/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.core;

import com.creamtec.core.StringUtilities;
import com.creamtec.core.Utilities;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.rmi.ConnectException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

public class TraceMgr {
    public static final boolean DEBUG = true;
    public static boolean mPrintDate = false;
    public static final boolean DEFAULT_CLASS_TRACE_ENABLED = true;
    public static int DEFAULT_CUTOFF_LEVEL = 5;
    public static int DEFAULT_TRACE_LEVEL = 5;
    public static int DEFAULT_WARNING_LEVEL = 3;
    public static int DEFAULT_ERROR_LEVEL = 2;
    public static int DEFAULT_CLASS_LEVEL = 255;
    public static final String PROPERTIES_FILE_NAME = "TraceMgr.properties";
    protected static int cutoffLevel = DEFAULT_CUTOFF_LEVEL;
    protected static Date mDate = new Date();
    protected static StringBuffer mMsg = new StringBuffer(1000);
    protected static SimpleDateFormat mFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
    protected static Properties mSettings = null;
    protected static boolean writeToConsole = true;
    protected static Writer mFileWriter = null;
    protected static boolean mEnable = true;
    protected static boolean mPrintThreadId = true;
    protected static boolean loadSettings = true;
    protected static boolean writeToFile = true;
    protected static String logFileName = "default.log";
    protected static boolean mInitialized;

    public static void trace(String msg) {
        TraceMgr.trace(msg, DEFAULT_TRACE_LEVEL);
    }

    public static synchronized void trace(String msg, int level) {
        if (level <= TraceMgr.getCutoffLevel() && mEnable) {
            mMsg.setLength(0);
            if (mPrintDate) {
                mDate.setTime(System.currentTimeMillis());
                String date = mFormat.format(mDate);
                mMsg.append(date);
                mMsg.append(" : ");
            }
            if (mPrintThreadId) {
                mMsg.append(Thread.currentThread().getName());
                mMsg.append(" : ");
            }
            mMsg.append(msg);
            msg = mMsg.toString();
            TraceMgr.println(msg);
            TraceMgr.printLog(msg, true, true);
        }
    }

    protected static void println(String str) {
        if (writeToConsole) {
            System.out.println(str);
        }
    }

    protected static void print(String str) {
        if (writeToConsole) {
            System.out.print(str);
        }
    }

    protected static void printLog(String str, boolean newLine, boolean flush) {
        if (mFileWriter != null) {
            try {
                mFileWriter.write(str);
                if (newLine) {
                    mFileWriter.write("\r\n");
                }
                if (flush) {
                    mFileWriter.flush();
                }
            }
            catch (IOException x) {
                TraceMgr.println("Failed to write to log file");
                x.printStackTrace();
            }
        }
    }

    public static int getCutoffLevel() {
        if (!mInitialized) {
            TraceMgr.init();
        }
        return cutoffLevel;
    }

    public static void setCutoffLevel(int cutoffLevel) {
        TraceMgr.cutoffLevel = cutoffLevel;
    }

    public static void setFileWriter(Writer writer) {
        mFileWriter = writer;
    }

    public static Writer getFileWriter() {
        return mFileWriter;
    }

    public static void newLine() {
        TraceMgr.trace("");
    }

    public static void trace(Object obj, String msg) {
        TraceMgr.trace(obj, msg, DEFAULT_TRACE_LEVEL);
    }

    public static void trace(Object obj, String msg, int level) {
        if (level <= TraceMgr.getCutoffLevel() && obj != null) {
            TraceMgr.trace(obj.getClass(), msg, level);
        }
    }

    public static void trace(Object obj, String msg, Throwable x) {
        TraceMgr.trace(obj, msg, x, DEFAULT_ERROR_LEVEL);
    }

    public static void trace(Object obj, String msg, Throwable x, int level) {
        if (level <= TraceMgr.getCutoffLevel() && obj != null) {
            TraceMgr.trace(obj.getClass(), msg, x);
        }
    }

    public static void trace(Class cls, String msg) {
        TraceMgr.trace(cls, msg, DEFAULT_TRACE_LEVEL);
    }

    public static void trace(Class cls, String msg, int level) {
        if (level <= TraceMgr.getCutoffLevel() && level <= TraceMgr.getTraceLevel(cls)) {
            StringBuffer className = new StringBuffer(500);
            className.append("[");
            className.append(cls.getName());
            className.append("] ");
            className.append(msg);
            TraceMgr.trace(className.toString(), level);
        }
    }

    public static String className(Class cls, String msg) {
        StringBuffer className = new StringBuffer(500);
        className.append("[");
        className.append(cls.getName());
        className.append("] ");
        className.append(msg);
        return className.toString();
    }

    public static void trace(Class cls, String msg, Throwable x) {
        TraceMgr.trace(cls, msg, x, DEFAULT_ERROR_LEVEL);
    }

    public static void trace(Class cls, String msg, Throwable x, int level) {
        if (level <= TraceMgr.getCutoffLevel()) {
            TraceMgr.trace(cls, TraceMgr.getExceptionText(msg, x), level);
            if (TraceMgr.getWriteToConsole()) {
                if (mPrintDate) {
                    mDate.setTime(System.currentTimeMillis());
                    String date = mFormat.format(mDate) + " : ";
                    System.err.print(date);
                }
                System.err.println(TraceMgr.className(cls, msg));
            }
            if (TraceMgr.getWriteToConsole()) {
                x.printStackTrace();
                x.printStackTrace(System.out);
            }
            if (writeToFile && mFileWriter != null) {
                x.printStackTrace(new PrintWriter(mFileWriter));
            }
        }
        if (writeToFile && mFileWriter != null) {
            try {
                mFileWriter.flush();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void trace(String msg, Throwable x) {
        TraceMgr.trace(msg, x, DEFAULT_ERROR_LEVEL);
    }

    public static void trace(String msg, Throwable x, int level) {
        if (level <= TraceMgr.getCutoffLevel()) {
            mDate.setTime(System.currentTimeMillis());
            TraceMgr.trace(TraceMgr.getExceptionText(msg, x), level);
            if (TraceMgr.getWriteToConsole()) {
                if (mPrintDate) {
                    String date = mFormat.format(mDate) + " : ";
                    System.err.print(date);
                }
                System.err.println(msg);
            }
            if (TraceMgr.getWriteToConsole()) {
                x.printStackTrace();
                x.printStackTrace(System.out);
            }
            if (mFileWriter != null) {
                x.printStackTrace(new PrintWriter(mFileWriter));
            }
        }
    }

    public static String getExceptionText(String msg, Throwable x) {
        return TraceMgr.getExceptionText(msg, x, true);
    }

    public static String getExceptionText(String msg, Throwable x, boolean detailed) {
        InvocationTargetException ix;
        if (x == null) {
            return " (No exception informtion is available)";
        }
        StringBuffer msgBuf = new StringBuffer(500);
        msgBuf.append(msg);
        if (x instanceof InvocationTargetException && (ix = (InvocationTargetException)x).getTargetException() != null) {
            x = ix.getTargetException();
        }
        if (detailed) {
            msgBuf.append(" (Exception ");
            msgBuf.append(x.getClass().getName());
            if (x.getMessage() != null && x.getMessage().length() != 0) {
                msgBuf.append(", ");
                msgBuf.append(x.getMessage());
            }
            msgBuf.append(')');
        } else if (x.getClass().getName().startsWith("java.net") || x instanceof ConnectException) {
            msgBuf.append(" (network failure)");
        } else if (x.getClass().getName().startsWith("java.rmi")) {
            msgBuf.append(" (server error)");
        } else if (x.getClass().getName().startsWith("java.sql")) {
            msgBuf.append(" (Database error)");
        } else if (msg == null || msg.length() == 0) {
            msgBuf.append(x.getMessage());
        }
        return msgBuf.toString();
    }

    public static final int getTraceLevel(Object obj) {
        return TraceMgr.getTraceLevel(obj.getClass());
    }

    public static final int getTraceLevel(Class cls) {
        int dotIndex;
        if (!loadSettings) {
            return DEFAULT_CLASS_LEVEL;
        }
        String name = cls.getName();
        String value = null;
        while ((value = (String)mSettings.get(name)) == null && (dotIndex = name.lastIndexOf(46)) != -1) {
            name = name.substring(0, dotIndex);
        }
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception x) {
                TraceMgr.trace("Invalid trace level " + value, x);
            }
        }
        return DEFAULT_CLASS_LEVEL;
    }

    public static void loadSettings() throws Exception {
        if (mSettings == null) {
            mSettings = new Properties();
            String fileName = Utilities.getConfFullPath(PROPERTIES_FILE_NAME);
            FileInputStream fis = new FileInputStream(fileName);
            BufferedInputStream bis = new BufferedInputStream(fis);
            mSettings.load(bis);
            bis.close();
            fis.close();
        }
    }

    protected static synchronized void init() {
        String value;
        if (mInitialized) {
            return;
        }
        mInitialized = true;
        if (!loadSettings) {
            return;
        }
        try {
            TraceMgr.loadSettings();
            value = (String)mSettings.get("com.creamtec.core.TraceMgr.console");
            if (value != null && value.equalsIgnoreCase("false")) {
                writeToConsole = false;
            }
            if ((value = (String)mSettings.get("com.creamtec.core.TraceMgr.level")) != null) {
                try {
                    TraceMgr.setCutoffLevel(Integer.parseInt(value.trim()));
                }
                catch (NumberFormatException x) {
                    x.printStackTrace();
                }
            }
            if ((value = (String)mSettings.get("com.creamtec.core.TraceMgr.enable")) != null && value.equalsIgnoreCase("false")) {
                mEnable = false;
            }
            if ((value = (String)mSettings.get("com.creamtec.core.TraceMgr.printDate")) != null && value.equalsIgnoreCase("true")) {
                mPrintDate = true;
            }
            if ((value = (String)mSettings.get("com.creamtec.core.TraceMgr.printThreadId")) != null && value.equalsIgnoreCase("false")) {
                mPrintThreadId = false;
            }
        }
        catch (Exception x) {
            TraceMgr.trace("[TraceMgr] Warning: failed to load Trace Manager properties. Make sure com.creamtec.home system property is set using -D switch for java", x);
        }
        value = null;
        try {
            value = (String)mSettings.get("com.creamtec.core.TraceMgr.logdir");
            value = StringUtilities.replaceParameters(value, System.getProperties());
            if (writeToFile && TraceMgr.getFileWriter() == null && value != null) {
                value = value + File.separatorChar + TraceMgr.getLogFileName();
                if (writeToConsole) {
                    System.out.println("[TraceMgr] Opening log file " + value);
                }
                mFileWriter = new BufferedWriter(new FileWriter(value, true));
            }
            String fileName = Utilities.getConfFullPath(PROPERTIES_FILE_NAME);
            TraceMgr.trace("Read TraceMgr properties from file " + fileName, 6);
            value = (String)mSettings.get("com.creamtec.core.TraceMgr.dumpSystemInfo");
            if (value != null && value.equalsIgnoreCase("true")) {
                TraceMgr.dumpSystemInfo();
            }
        }
        catch (SecurityException x) {
            TraceMgr.trace("[TraceMgr] Warning: failed to open log file for writing " + value, x);
        }
        catch (Exception x) {
            TraceMgr.trace("[TraceMgr] Warning: failed to open log file for writing " + value, x);
        }
    }

    public static void dumpSystemInfo() {
        Properties props = System.getProperties();
        TraceMgr.trace("SYSTEM PROPERTIES:");
        Enumeration<Object> i = props.keys();
        while (i.hasMoreElements()) {
            String key = (String)i.nextElement();
            TraceMgr.trace(key + " = " + props.getProperty(key));
        }
    }

    public static synchronized void printStackTrace() {
        TraceMgr.printStackTrace(DEFAULT_CUTOFF_LEVEL);
    }

    public static synchronized void printStackTrace(int cutoffLevel) {
        StringBuilder stacktrace = new StringBuilder("StackTrace:");
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            stacktrace.append('\n');
            stacktrace.append(String.format("%s %s %s %s", element.getFileName(), element.getClassName(), element.getMethodName(), element.getLineNumber()));
        }
        TraceMgr.trace(stacktrace.toString(), cutoffLevel);
    }

    public static void setLogFileName(String fileName) {
        logFileName = fileName;
    }

    public static String getLogFileName() {
        return logFileName;
    }

    public static void setLoadSettings(boolean load) {
        loadSettings = load;
    }

    public static void setWriteToFile(boolean write) {
        writeToFile = write;
    }

    public static boolean getWriteToFile() {
        return writeToFile;
    }

    public static void setWriteToConsole(boolean write) {
        writeToConsole = write;
    }

    public static boolean getWriteToConsole() {
        return writeToConsole;
    }
}

