package com.creamtec.ajaxswing.core.util;

/**
 * Created 17.09.2008 19:41:21
 * <p>
 * Update packet used by ComponentUpdateManager
 * @author Alexander Kislitsyn
 *
 */
public class UpdatePacket
{
	public static final int TYPE_NONE = 0x00;
	public static final int TYPE_ADD = 0x01;
	public static final int TYPE_UPDATE = 0x02;
	public static final int TYPE_DELETE = 0x03;
	
	public static final UpdatePacket EMPTY = new UpdatePacket(0, TYPE_NONE, null);
	
	private int id;
	private int type;
	private Object data;

	
	public UpdatePacket(int id, int type, Object data)
	{
		this.id = id;
		this.type = type;
		this.data = data;
	}
	
	/**
	 * @return the id
	 */
	public int getId()
	{
		return this.id;
	}
	
	/**
	 * @param type the type to set
	 */
	public void setType(int type)
	{
		this.type = type;
	}
	
	/**
	 * @return the type
	 */
	public int getType()
	{
		return this.type;
	}
	
	/**
	 * @return the data
	 */
	public Object getData()
	{
		return this.data;
	}

	public boolean equals(Object obj)
	{
		if (obj != null && obj instanceof UpdatePacket)
		{
			UpdatePacket packet = (UpdatePacket)obj;
			return this.getData().equals(packet.getData());
		}
		return false;
	}
	
	public String typeToString(int type)
	{
		switch (type)
		{
			case TYPE_NONE:
				return "NONE";
			case TYPE_ADD:
				return "ADD";
			case TYPE_UPDATE:
				return "UPDATE";
			case TYPE_DELETE:
				return "DELETE";
		}
		return "UNKNOWN";
	}
	
	public String toString()
	{
		return "[" + this.id + ": " + this.typeToString(this.getType()) + ": " + this.getData().toString() + "]";
	}
}
