package com.creamtec.ajaxswing.support;

import javax.swing.JPopupMenu;
import javax.swing.tree.TreeNode;

/**
 * JTree subclasses can implement this interface to provide additional information to AjaxSwing  
 *
 */
public interface TreeSupport {
    /**
     * Returns context menu associated with the given row
     * @param node node being rendered
     * @return context menu to display when the user clicks right mouse button
     */
    public JPopupMenu getNodeContextMenu(TreeNode node);
    
    /**
     * Returns the name of the image bundle that will be used in rendering of the node 
     * @param node node being rendered
     * @return tree image bundle name (default is used if null is returned)
     */
    public String getNodeImageBundleName(TreeNode node);
    
    /**
     * Returns the relative path to the theme docs URL of the image that should be used for the node 
     * @param node node being rendered
     * @return path such as "/images/ajaxswing/tree/FolderOpen.gif"
     */
    public String getNodeImagePath(TreeNode node, int imageIndex);
    
    
	public final static int IMG_BLANK = 0;
	public final static int IMG_LINE = 1;
	public final static int IMG_ITEM = 2;
	public final static int IMG_LAST_ITEM = 3;
	public final static int IMG_FOLDER_EXPANDED = 4;
	public final static int IMG_FOLDER_COLLAPSED = 5;
	public final static int IMG_LAST_FOLDER_EXPANDED = 6;
	public final static int IMG_LAST_FOLDER_COLLAPSED = 7;
	public final static int IMG_ROOT_FOLDER_EXPANDED = 8;
	public final static int IMG_ROOT_FOLDER_COLLAPSED = 9;
	public final static int IMG_ROOT_LAST_FOLDER_EXPANDED = 10;
	public final static int IMG_ROOT_LAST_FOLDER_COLLAPSED = 11;
	
	final static String[] DEFAULT_NODE_IMAGE_NAMES = { 
		"/images/ajaxswing/tree/Blank.gif", 
		"/images/ajaxswing/tree/Line.gif", 
		"/images/ajaxswing/tree/Item.gif", 
		"/images/ajaxswing/tree/LastItem.gif", 
		"/images/ajaxswing/tree/FolderOpen.gif", 
		"/images/ajaxswing/tree/FolderClosed.gif", 
		"/images/ajaxswing/tree/FolderLastOpen.gif", 
		"/images/ajaxswing/tree/FolderLastClosed.gif", 
		"/images/ajaxswing/tree/RootFolderOpen.gif", 
		"/images/ajaxswing/tree/RootFolderClosed.gif", 
		"/images/ajaxswing/tree/RootLastFolderOpen.gif", 
		"/images/ajaxswing/tree/RootLastFolderClosed.gif" 
	};

}
