package com.creamtec.ajaxswing.ui;

import java.util.List;

import javax.swing.table.AbstractTableModel;

public class ArrayTableModel extends AbstractTableModel {
    private List data;
    String[] columnNames;
    String[] editableColumns;

    public ArrayTableModel(List data, String[] columnNames, String[] editableColumns) {
        this.data = data;
        this.columnNames = columnNames;
        this.editableColumns = editableColumns;
    }

    // These methods always need to be implemented.
    public int getColumnCount() {
        return columnNames.length;
    }

    public int getRowCount() {
        return data.size();
    }

    public Object getValueAt(int row, int col) {
        if (row < data.size()) {
            Object[] rowData = (Object[]) data.get(row);
            return rowData[col];
        }
        else
            return null;
    }

    public List getData() {
        return data;
    }

    public void setData(List data) {
        this.data = data;
        fireTableDataChanged();
    }

    public String[] getColumnNames() {
        return columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public String getColumnName(int column) {
        return columnNames[column];
    }

    public Class getColumnClass(int c) {
        return getValueAt(0, c).getClass();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.editableColumns != null) {
            String columnName = getColumnName(columnIndex);
            for (int i = 0; i < this.editableColumns.length; i++) {
                if(columnName.equals(this.editableColumns[i]))
                    return true;
            }
        }
        return false;
    }
    
    // Have to clone values because the editor reuses them
    public void setValueAt(Object value, int row, int column) {
        try {
            Object[] rowData = (Object[]) data.get(row);
            rowData[column] = value;
        } catch (Exception x) {
            x.printStackTrace();
        }
    }
    
    public void clear() {
        this.data.clear();
    }

    public void addRow(int index, Object row) {
        this.data.add(index, row);
        fireTableDataChanged();
    }
    
    public void removeRow(int index) {
        this.data.remove(index);
        fireTableDataChanged();
    }
    
}
