package com.creamtec.ajaxswing.ui;

import  java.awt.*;
import  java.awt.event.*;
import  javax.swing.*;

public class AwtDialog
    extends Dialog
{

    Panel panel1 = new Panel();
    protected GridBagLayout gridBagLayout1 = new GridBagLayout();
    protected Label label1 = new Label();
    protected Checkbox chkOption1 = new Checkbox();
    protected CheckboxGroup chkGroup = new CheckboxGroup();
    protected Checkbox rbtChoice1 = new Checkbox();
    protected Checkbox rbtChoice2 = new Checkbox();
    protected Button btnClose = new Button();
    protected Choice choice1 = new Choice();
    protected List list1 = new List();
    protected TextField txfText = new TextField();
    protected TextArea txaText = new TextArea();


    public AwtDialog (Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        enableEvents(AWTEvent.WINDOW_EVENT_MASK);

        try {
            jbInit();
            add(panel1);

            for (int i = 1; i < 10; i++) {
                this.choice1.addItem("Item " + i);
                this.list1.add("Item " + i);
            }

//            pack(); - todo: eventually fix the sizing issue so that pack() works in HTML
            setSize(400, 300);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }

        this.setLocationRelativeTo(null);
    }


    public AwtDialog (Frame frame) {
        this(frame, "AWT Dialog with events", false);
    }


    public AwtDialog (Frame frame, boolean modal) {
        this(frame, "AWT Dialog with events", modal);
    }


    public AwtDialog (Frame frame, String title) {
        this(frame, title, false);
    }


    void jbInit ()
        throws Exception
    {
        label1.setText("Components below have listeneres");
        panel1.setLayout(gridBagLayout1);
        chkOption1.setLabel("Option 1");
        chkOption1.addItemListener(new java.awt.event.ItemListener() {

            public void itemStateChanged (ItemEvent e) {
                chkOption1_itemStateChanged(e);
            }

        });
        rbtChoice1.setCheckboxGroup(chkGroup);
        rbtChoice1.setLabel("Choice 1");
        rbtChoice1.setState(true);
        rbtChoice1.addItemListener(new java.awt.event.ItemListener() {

            public void itemStateChanged (ItemEvent e) {
                rbtChoice1_itemStateChanged(e);
            }

        });
        rbtChoice2.setCheckboxGroup(chkGroup);
        rbtChoice2.setLabel("Choice 2");
        rbtChoice2.addItemListener(new java.awt.event.ItemListener() {

            public void itemStateChanged (ItemEvent e) {
                rbtChoice2_itemStateChanged(e);
            }

        });
        btnClose.setLabel("Close");
        btnClose.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed (ActionEvent e) {
                btnClose_actionPerformed(e);
            }

        });
        choice1.addItemListener(new java.awt.event.ItemListener() {

            public void itemStateChanged (ItemEvent e) {
                choice1_itemStateChanged(e);
            }

        });
        list1.addItemListener(new java.awt.event.ItemListener() {

            public void itemStateChanged (ItemEvent e) {
                list1_itemStateChanged(e);
            }

        });
        list1.setMultipleMode(true);
        txfText.setText("sample text");
        txfText.addTextListener(new java.awt.event.TextListener() {
            public void textValueChanged(TextEvent e) {
                txfText_textValueChanged(e);
            }
        });
        txaText.setText("sample text area");
        txaText.addTextListener(new java.awt.event.TextListener() {
            public void textValueChanged(TextEvent e) {
                txaText_textValueChanged(e);
            }
        });
        txaText.setColumns(20);
        txaText.setRows(3);
        panel1.add(label1,   new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 0, 0), 0, 0));
        panel1.add(chkOption1,   new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 0, 0), 0, 0));
        panel1.add(rbtChoice1,    new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 0, 0), 0, 0));
        panel1.add(rbtChoice2,      new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 0, 0), 0, 0));
        panel1.add(choice1,   new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 20, 0, 0), 0, 0));
        panel1.add(list1,   new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 0, 0), 0, 0));
        panel1.add(btnClose,   new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 0, 0), 0, 0));
        panel1.add(txfText,   new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
        panel1.add(txaText,   new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    }


    protected void processWindowEvent (WindowEvent e) {
        if (e.getID() == WindowEvent.WINDOW_CLOSING) {
            cancel();
        }

        super.processWindowEvent(e);
    }


    void cancel () {
        dispose();
    }


    void btnClose_actionPerformed (ActionEvent e) {
        dispose();
    }


    void rbtChoice1_itemStateChanged (ItemEvent e) {
        if (rbtChoice1.getState() == true) {
            JOptionPane.showMessageDialog(this, "You have selected Choice 1", "EVENT RECEIVED", JOptionPane.INFORMATION_MESSAGE);
        }
    }


    void rbtChoice2_itemStateChanged (ItemEvent e) {
        if (rbtChoice2.getState() == true) {
            JOptionPane.showMessageDialog(this, "You have selected Choice 2", "EVENT RECEIVED", JOptionPane.INFORMATION_MESSAGE);
        }
    }


    void chkOption1_itemStateChanged (ItemEvent e) {
        JOptionPane.showMessageDialog(this, "You have changed Option 1", "EVENT RECEIVED", JOptionPane.INFORMATION_MESSAGE);
    }


    void choice1_itemStateChanged (ItemEvent e) {
        if (rbtChoice1.getState() == true) {
            JOptionPane.showMessageDialog(this, "You have selected: " + choice1.getSelectedItem(), "EVENT RECEIVED", JOptionPane.INFORMATION_MESSAGE);
        }
    }


    void list1_itemStateChanged (ItemEvent e) {
        JOptionPane.showMessageDialog(this, "You have selected: " + list1.getSelectedItem(), "EVENT RECEIVED", JOptionPane.INFORMATION_MESSAGE);
    }


    void txfText_textValueChanged(TextEvent e) {
        JOptionPane.showMessageDialog(this, "You have entered: " + this.txfText.getText(), "EVENT RECEIVED", JOptionPane.INFORMATION_MESSAGE);
    }

    void txaText_textValueChanged(TextEvent e) {
        JOptionPane.showMessageDialog(this, "You have entered: " + this.txaText.getText(), "EVENT RECEIVED", JOptionPane.INFORMATION_MESSAGE);
    }

}

