package com.creamtec.ajaxswing.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableModel;

import com.creamtec.ajaxswing.support.TableSupport;

public class CustomTable extends JTable implements TableSupport {
    JPopupMenu menu = new JPopupMenu();

    public CustomTable() {
        initMenu();
    }

    public CustomTable(TableModel dm) {
        super(dm);
        initMenu();
    }
    
    protected void initMenu() {
        JMenuItem item = new JMenuItem("Archive this email");
        item.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                int[] indexes = getSelectedRows();
                ArrayTableModel model = (ArrayTableModel) getModel();
                for (int i = indexes.length - 1; i >= 0; i--)
                    model.removeRow(indexes[i]);
                JOptionPane.showMessageDialog(null, "Email Archived");
            }
        });
        this.menu.add(item);
        
    }

    public JPopupMenu getContextMenu(int row) {
        if (row == 2) {
            return this.menu;
        }
        return null;
    }


}
