/**
 * Copyright 2000 by CreamTec, LLC. All rights reserved.
 */
package com.creamtec.ajaxswing.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.geom.GeneralPath;
import java.io.File;
import java.util.Date;

import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.WindowConstants;
import javax.swing.tree.DefaultMutableTreeNode;

import com.creamtec.ajaxswing.AjaxSwingManager;
import com.creamtec.ajaxswing.gui.VersionHelper;
import com.creamtec.ajaxswing.support.FileOpener;
import com.creamtec.ajaxswing.support.components.AccordionPane;
import com.creamtec.ajaxswing.support.components.JEditorPane;
import com.creamtec.ajaxswing.support.old.ComponentUtils;
import com.creamtec.core.TraceMgr;

public class DemoFrame extends JFrame implements FileOpener {
    boolean exitSystem = true;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel pnlSouth = new JPanel();
    final JSplitPane mainSplitPane = new JSplitPane();
    JSplitPane rightSplitPane = new JSplitPane();
    JEditorPane jtaHint = new JEditorPane();
    AccordionPane accordionPanel = new AccordionPane();
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu mnuFile = new JMenu();
    JMenuItem mniExit = new JMenuItem();
    JMenu mnuTools = new JMenu();
    JMenuItem mniLoginDialog = new JMenuItem();
    JMenuItem mniRegistrationDialog = new JMenuItem();
    JMenu mnuHelp = new JMenu();
    JMenuItem mniAbout = new JMenuItem();
    JMenuItem mniPreferencesDialog = new JMenuItem();
    JMenuItem mniSplitPaneDialog = new JMenuItem();
    protected JMenuItem mniFixedDialog = new JMenuItem();
    protected JMenuItem mniAwtDialog = new JMenuItem();
    protected JMenuItem mniForeignDialog = new JMenuItem();
    protected JMenu mnuFileHelp = new JMenu();
    protected JMenuItem mniFileHelpAbout = new JMenuItem();
    private TreePanel treePanel;
    protected boolean testMultithreading = false;

    public DemoFrame() {
        this(true);
    }

    public DemoFrame(boolean exitSystem) {
        this.exitSystem = exitSystem;

        try {
            jbInit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(final String[] args) throws Exception {
        trace("Running test frame 1");
        final DemoFrame frame = new DemoFrame();

        if (args.length > 0) {
            trace("Argument[0] = " + args[0]);
            frame.testMultithreading = "multithreading".equals(args[0]);
        }

//        AjaxSwingManager.beginOperation();
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                trace("Making visible");
                frame.setVisible(true);
                
                if (frame.testMultithreading) {
                    new Thread() {
                        public void run() {
                            try {
                                Thread.sleep(2000);
                            } catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            frame.doRegistration(frame);
//                            frame.jtaHint.setText("<h1>Async Update</h1>");
                        }
                    }.start();
                }
                
//                AjaxSwingManager.endOperation();
                
                if (args.length > 0 && "registration".equals(args[0])) {
                    frame.doRegistration(frame);
                }
                
                ComponentUtils.setPopupMenu(frame.getContentPane(), frame.createFrameContextMenu());
            }
        });
        
        trace("Main finished");
    }

    static void trace(String msg) {
        TraceMgr.trace(DemoFrame.class, msg);
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
        this.setTitle("AjaxSwing WebMail");
        this.setExtendedState(Frame.MAXIMIZED_BOTH);
        
        if (AjaxSwingManager.isAjaxSwingRunning()) {
           this.setUndecorated(true);
        }
        
        this.addWindowListener(new java.awt.event.WindowAdapter() {

            public void windowClosing(WindowEvent e) {
                this_windowClosing(e);
            }

        });
        
        // jTextArea1.setLineWrap(true);
        // jTextArea1.setColumns(50);
        jtaHint.setEditable(false);
        jtaHint.setContentType("text/html");
        pnlSouth.setOpaque(false);
        
        mnuFile.setText("File");
        mniExit.setText("Exit");
        mniExit.setIcon(new ImageIcon(getClass().getResource("/images/StopServer.gif")));
        mniExit.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(ActionEvent e) {
                mniExit_actionPerformed(e);
            }

        });
        mnuTools.setText("Tools");
        
        mniLoginDialog.setText("Login Dialog (Mouse Events)");
        mniLoginDialog.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                new LoginDialog().setVisible(true);
                mniLoginDialog.setText("Login (" + new Date() + ")");
                DemoFrame.this.accordionPanel.update(mnuTools);
            }
        });
        
        mniRegistrationDialog.setText("Registration Dialog");
        mniRegistrationDialog.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                doRegistration(DemoFrame.this);
            }
        });
        
        mnuHelp.setText("Help");
        mniAbout.setEnabled(false);
        mniAbout.setText("About... (disabled)");
        mniPreferencesDialog.setText("Preferences");
        mniPreferencesDialog.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                mniPreferencesDialog_actionPerformed(e);
            }
        });
        
        mniSplitPaneDialog.setText("SplitPane Test");
        mniSplitPaneDialog.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                new SplitPaneDialog().setVisible(true);
            }
        });

        mniFixedDialog.setText("Fixed Dialog (File Open/Save)");
        mniFixedDialog.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(ActionEvent e) {
                mniFixedDialog_actionPerformed(e);
            }

        });
        JMenuItem mniUploadFile = new JMenuItem("Upload File");
        mniUploadFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(DemoFrame.this, "Thanks for uploading file");
            }
        });
        //ComponentUtils.setFileOpener(mniUploadFile, this);
        
        
        mniAwtDialog.setText("AWT with events");
        mniAwtDialog.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(ActionEvent e) {
                mniAwtDialog_actionPerformed(e);
            }

        });
        mniForeignDialog.setText("(Foreign Language Dialog)");
        mniForeignDialog.setText("\u0420\u0443\u0441\u0441\u043A\u0438\u0439 \u0414\u0438\u0430\u043B\u043E\u0433 (Foreign Language Dialog)");
        mniForeignDialog.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                mniForeignDialog_actionPerformed(e);
            }
        });
        mnuFileHelp.setText("Help");
        mnuFileHelp.setIcon(new ImageIcon(getClass().getResource("/images/StartServer.gif")));
        mniFileHelpAbout.setText("About...");
        mniFileHelpAbout.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                mniFileHelpAbout_actionPerformed(e);
            }
        });

        this.getContentPane().setLayout(borderLayout1);
        this.getContentPane().add(jtaHint, BorderLayout.NORTH);
        this.getContentPane().add(mainSplitPane, BorderLayout.CENTER);
        this.getContentPane().add(pnlSouth, BorderLayout.SOUTH);
        jMenuBar1.add(mnuFile);
        jMenuBar1.add(mnuTools);
        jMenuBar1.add(mnuHelp);
        mnuFile.add(mnuFileHelp);
        mnuFile.addSeparator();
        mnuFile.add(mniExit);
        mnuTools.add(mniRegistrationDialog);
        mnuTools.add(mniLoginDialog);
        mnuTools.add(mniPreferencesDialog);
        mnuTools.addSeparator();
        mnuTools.add(mniFixedDialog);
        mnuTools.add(mniUploadFile);
        //mnuTools.add(mniSplitPaneDialog);
        
        // mnuDialogs.add(mniAwtDialog);
        mnuTools.add(mniForeignDialog);
        mnuHelp.add(new JCheckBoxMenuItem("Expert Mode"));
        mnuHelp.add(mniAbout);
        
        JMenu about = new JMenu("About a very long line");
        about.add(new JMenuItem("Do nothing"));
        mnuHelp.add(about);
        
        mnuFileHelp.add(mniFileHelpAbout);
        
        // create the rightmost button
        jMenuBar1.add(Box.createHorizontalGlue());
        JButton logoButton = new JButton(new ImageIcon(DemoFrame.class.getResource("/images/webcream.gif")));
        logoButton.setContentAreaFilled(false);
        logoButton.setBorder(null);
        logoButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                mniFileHelpAbout_actionPerformed(e);
            }
        });
        jMenuBar1.add(logoButton);
        
        this.setJMenuBar(jMenuBar1);
        
        // Init split panes
        this.treePanel = new TreePanel(this, "Anonymous");
        accordionPanel.add("Mailbox", treePanel);
        accordionPanel.add(mnuTools);
        accordionPanel.add(mnuFile);
        accordionPanel.setPreferredSize(new Dimension(180, 100));

        mainSplitPane.setLeftComponent(accordionPanel);   
        mainSplitPane.setRightComponent(rightSplitPane);
        mainSplitPane.setDividerLocation(250);
        
        rightSplitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
        rightSplitPane.setTopComponent(treePanel.emailsPane);
        rightSplitPane.setBottomComponent(treePanel.emailPane);
        rightSplitPane.setDividerLocation(200);
        
        jtaHint.setText("<b>Hint:</b> This is a simple implementation of Mail client. Click on mailbox folders to see partial page updates. Notice the sorting and filtering of the JTable<p>");
        this.setSize(500, 400);

    }

    private JPopupMenu createFrameContextMenu() {
        final JPopupMenu contextMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Set Frame Background to Blue");
        item.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                getContentPane().setBackground(new Color(205, 223, 249));
            }
        });
        contextMenu.add(item);

        item = new JMenuItem("Set Frame Background to Khaki");
        item.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                getContentPane().setBackground(new Color(255, 251, 229));
            }
        });
        contextMenu.add(item);

        contextMenu.addSeparator();

        item = new JMenuItem("About AjaxSwing...");
        item.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                javax.swing.JOptionPane optionPane = new javax.swing.JOptionPane();
                optionPane.showMessageDialog(null, "AjaxSwing is awesome!", "About AjaxSwing", JOptionPane.PLAIN_MESSAGE);
            }
        });
        contextMenu.add(item);
        return contextMenu;
    }

    void mniExit_actionPerformed(ActionEvent e) {
        checkExit();
    }

    void mniPreferencesDialog_actionPerformed(ActionEvent e) {
        Window dlg = new TabbedDialog();
        dlg.setVisible(true);
    }

    void this_windowClosing(WindowEvent e) {
        checkExit();
    }

    void checkExit() {
        int i = JOptionPane.showConfirmDialog(this, "Do you want to end this session?\n\nReally?", "Confirm", JOptionPane.YES_NO_OPTION);

        try {
            // Just to confuse AjaxSwing
            if (this.testMultithreading) {
                Thread.sleep(500);
            }
        } catch (Exception x) {
        }
        if (i == JOptionPane.YES_OPTION) {
            if (this.exitSystem) {
                System.exit(0);
            } else {
                removeAll();
                dispose();
            }
        }
    }

    void mniFixedDialog_actionPerformed(ActionEvent e) {
        final Window dlg = new FixedDialog();
        dlg.setLocationRelativeTo(null);
        if (this.testMultithreading) {
            new Thread(new Runnable() {
                public void run() {
                    try {
                        Thread.sleep(2000);
                    }
                    catch(Exception x) {}
                    dlg.setVisible(true);
                }
            }).start();
        }
        else {
            dlg.setVisible(true);
        }
    }

    void mniAwtDialog_actionPerformed(ActionEvent e) {
        Dialog dlg = new AwtDialog(this);
        dlg.setLocationRelativeTo(null);
        dlg.setVisible(true);
    }

    void mniForeignDialog_actionPerformed(ActionEvent e) {
        Window dlg = new ForeignDialog();
        dlg.setLocationRelativeTo(null);
        dlg.setVisible(true);
    }

    void mniFileHelpAbout_actionPerformed(ActionEvent e) {
        JLabel aboutLabel = new JLabel("AjaxSwing version " + VersionHelper.getAjaxSwingVersion());
        aboutLabel.setIcon(new AboutIcon());
        JOptionPane.showMessageDialog(this, aboutLabel, "About AjaxSwing", JOptionPane.PLAIN_MESSAGE);
    }

    private void doRegistration(final DemoFrame frame) {
        try {
            RegistrationDialog dlg = new RegistrationDialog();
            dlg.setVisible(true);
            DefaultMutableTreeNode root = (DefaultMutableTreeNode) this.treePanel.jTree1.getModel().getRoot();
            root.setUserObject("Mailbox - " + dlg.getUserName());
        }
        catch (Exception x) {
            TraceMgr.trace(this, "Registration failed", x);
        }
    }
    
    public static class AboutIcon implements Icon {

        protected int width = 14;
        protected int height = 16;

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D) g;
            GeneralPath p1 = new GeneralPath();
            p1.moveTo(x, y);
            p1.lineTo(x + width, y + height / 2);
            p1.lineTo(x, y + height);
            p1.closePath();
            g.setColor(Color.blue);
            g2.fill(p1);
        }

        public int getIconHeight() {
            return height;
        }

        public int getIconWidth() {
            return width;
        }

    }

    public void openFile(File file) {
        JOptionPane.showMessageDialog(null, "Uploaded file length = " + file.length());
    }

}