package com.creamtec.ajaxswing.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.URL;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import com.creamtec.ajaxswing.support.FileOpener;
import com.creamtec.ajaxswing.support.old.ComponentUtils;
import com.creamtec.core.TraceMgr;

public class FixedDialog extends JDialog implements FileOpener {
    JPanel panel1 = new JPanel();
    protected JLabel jLabel1 = new JLabel();
    protected JTextField txfName = new JTextField();
    protected JLabel jLabel2 = new JLabel();
    protected JTextField txfEmail = new JTextField();
    protected JLabel jLabel3 = new JLabel();
    protected JScrollPane jScrollPane1 = new JScrollPane();
    protected JTextArea txaAddress = new JTextArea();
    protected JComboBox cmbComments = new JComboBox();
    protected JLabel jLabel4 = new JLabel();
    protected JButton btnOK = new JButton();
    protected JButton btnCancel = new JButton();
    protected CustomControl customControl = new CustomControl();
    protected JTextField customTextField = new JTextField();
    private JButton btnImport = new JButton();
    JButton btnExport = new JButton();

    public FixedDialog(String title) {
        super((Frame)null, title, false);
        try {
            jbInit();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public FixedDialog() {
        this("");
    }

    void jbInit() throws Exception {
        panel1.setLayout(null);
//        this.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
        jLabel1.setText("Name");
        jLabel1.setBounds(new Rectangle(5, 5, 60, 20));
        txfName.setBounds(new Rectangle(71, 6, 98, 20));
        jLabel2.setText("Email");
        jLabel2.setBounds(new Rectangle(5, 41, 54, 20));
        txfEmail.setBounds(new Rectangle(71, 37, 98, 20));
        jLabel3.setText("Address");
        jLabel3.setBounds(new Rectangle(191, 8, 55, 20));
        jScrollPane1.setBounds(new Rectangle(250, 5, 132, 57));
        cmbComments.setBounds(new Rectangle(72, 100, 318, 20));
        cmbComments.setEditable(true);
        cmbComments.addItem("I really like AjaxSwing");
        cmbComments.addItem("AjaxSwing is pretty cool");
        cmbComments.addItem("AjaxSwing is OK");
        cmbComments.addItem("AjaxSwing sucks!");
        cmbComments.addItem("Why are you bugging me?");
        cmbComments.addItem("<Why are you bugging me?>");
        cmbComments.addItem("\\Why are you bugging me?\\");
        cmbComments.addItem("Why are you bugging me?");
        cmbComments.addItem("Why are you bugging me?");
        cmbComments.addItem("Why are you bugging me?");
        cmbComments.addItem("Why are you bugging me?");
        cmbComments.addItem("Why are you bugging me?");
        cmbComments.addItem("Why are you bugging me?");
        cmbComments.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                String text = (String) FixedDialog.this.cmbComments.getEditor().getItem();
                JOptionPane.showMessageDialog(FixedDialog.this, text, "Thank you for your opinion", JOptionPane.PLAIN_MESSAGE);
            }
        });

        jLabel4.setText("Comments");
        jLabel4.setBounds(new Rectangle(6, 99, 66, 26));
        URL imageUrl = getClass().getResource("/images/StartServer.gif");
        ImageIcon iconOK = new ImageIcon(imageUrl);
        imageUrl = getClass().getResource("/images/StopServer.gif");
        ImageIcon iconCancel = new ImageIcon(imageUrl);
        btnOK.setIcon(iconOK);
        btnOK.setText("OK");
        btnOK.setHorizontalTextPosition(SwingConstants.RIGHT);
        //        btnOK.setVerticalTextPosition(SwingConstants.LEFT);
        btnOK.setBounds(new Rectangle(130, 226, 75, 64));
        btnOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnOK_actionPerformed(e);
            }
        });
        btnCancel.setIcon(iconCancel);
        btnCancel.setText("Cancel");
        btnCancel.setHorizontalTextPosition(SwingConstants.CENTER);
        btnCancel.setVerticalTextPosition(SwingConstants.BOTTOM);
        btnCancel.setBounds(new Rectangle(230, 226, 78, 64));
        btnCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnCancel_actionPerformed(e);
            }
        });
        customControl.setText("Custom Control with Renderer and Updater");
        customControl.setBounds(new Rectangle(15, 186, 368, 25));
        this.setTitle("Dialog with null layout");
        
        JPanel panelBackground = new JPanel();
        panelBackground.setBackground(new Color(238,244,249));
        panelBackground.setBounds(390, 2, 86, 64);
        
        btnImport.setBounds(new Rectangle(395, 7, 76, 23));
        btnImport.setText("Import");
        btnImport.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                //        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
                chooser.setApproveButtonText("Select my file");
                //        int returnVal = chooser.showDialog(this, null);
                int returnVal = chooser.showOpenDialog(FixedDialog.this);
                if (returnVal == JFileChooser.APPROVE_OPTION) {
                    openFile(chooser.getSelectedFile());
                }
            }
        });
        //XXX REMOVED
        //ComponentUtils.setFileOpener(btnImport, this);
        
        btnExport.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnExport_actionPerformed(e);
            }
        });
        btnExport.setText("Export");
        btnExport.setBounds(new Rectangle(395, 36, 76, 23));
        getContentPane().add(panel1);
        panel1.add(jLabel1, null);
        panel1.add(jLabel2, null);
        panel1.add(txfEmail, null);
        panel1.add(txfName, null);
        panel1.add(jScrollPane1, null);
        panel1.add(cmbComments, null);
        panel1.add(jLabel4, null);
        panel1.add(btnCancel, null);
        panel1.add(btnOK, null);
        panel1.add(customControl, null);
        panel1.add(jLabel3, null);
        panel1.add(btnImport, null);
        panel1.add(btnExport, null);
        panel1.add(panelBackground, null);
        jScrollPane1.getViewport().add(txaAddress, null);
        this.setSize(new Dimension(486, 324));
        this.setLocationRelativeTo(null);
        
        ComponentUtils.getHtmlAttributes(txfName).put("tabIndex", "1");
        ComponentUtils.getHtmlAttributes(txaAddress).put("tabIndex", "2");
        ComponentUtils.getHtmlAttributes(btnImport).put("tabIndex", "3");
        ComponentUtils.getHtmlAttributes(btnExport).put("tabIndex", "4");
        ComponentUtils.getHtmlAttributes(txfEmail).put("tabIndex", "5");
        ComponentUtils.getHtmlAttributes(cmbComments).put("tabIndex", "6");
        ComponentUtils.getHtmlAttributes(customControl).put("tabIndex", "7");
        ComponentUtils.getHtmlAttributes(btnOK).put("tabIndex", "8");
        ComponentUtils.getHtmlAttributes(btnCancel).put("tabIndex", "9");
    }

    void btnOK_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    void btnCancel_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    void btnExport_actionPerformed(ActionEvent e) {
        TraceMgr.trace(this, "Exporting text " + this.txaAddress.getText(), 6);
        JFileChooser chooser = new JFileChooser();
        TraceMgr.trace(this, "Configuring the dialog...", 6);
        //        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        chooser.setApproveButtonText("Select file for export");
        TraceMgr.trace(this, "Setting selected file...", 6);
        chooser.setSelectedFile(new File("test.txt"));
        TraceMgr.trace(this, "Showing save dialog...", 6);
        int returnVal = chooser.showSaveDialog(this);
        TraceMgr.trace(this, "Save dialog returned", 6);
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            File file = chooser.getSelectedFile();
            TraceMgr.trace(this, "Exporting text to file " + file.getAbsolutePath());
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                writer.write(this.txaAddress.getText());
                writer.close();
            }
            catch (Exception x) {
                TraceMgr.trace("Failed to write to file " + file.getAbsolutePath(), x);
                JOptionPane.showMessageDialog(this, "Failed to write to file " + file.getAbsolutePath());
            }
        }

    }

    public void openFile(File file) {
        try {
            this.txaAddress.setText("");
            BufferedReader reader = new BufferedReader(new FileReader(file));
            for (int i = 0; i < 3; i++) {
                String line = reader.readLine();
                if (line == null)
                    break;
                this.txaAddress.setText(this.txaAddress.getText() + "\n" + line);
            }
            reader.close();
            JOptionPane.showMessageDialog(this, "Upload successful");
        }
        catch (Exception x) {
            TraceMgr.trace("Failed to read from file " + file.getAbsolutePath(), x);
            JOptionPane.showMessageDialog(this, "Failed to read from file " + file.getAbsolutePath());
        }
    }
    
}
