/**
 * Copyright 2000 by CreamTec, LLC. All rights reserved.
 */

package com.creamtec.ajaxswing.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import com.creamtec.ajaxswing.AjaxSwingManager;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.support.old.ComponentUtils;
import com.creamtec.core.TraceMgr;


public class RegistrationDialog extends JDialog {

    JPanel contentPanel = new JPanel();
    JPanel panelNorth = new JPanel();
    JPanel panelSouth = new JPanel();
    JButton btnCancel = new JButton();
    JButton btnOK = new JButton();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JTextPane jtaHint = new JTextPane();
    JLabel lblUser = new JLabel();
    JLabel lblUserEcho = new JLabel();
    JTextFieldValidatable txfUser = new JTextFieldValidatable();
    JPanel loginInfoPanel = new JPanel();
    JPanel userInfoPanel = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    JLabel lblPassword = new JLabel();
    JPasswordFieldValidatable txfPassword = new JPasswordFieldValidatable();
    JLabel lblBirthDate = new JLabel();
    JTextFieldValidatableDate txfBirthDate = new JTextFieldValidatableDate();
    JLabel lblAge = new JLabel();
    JTextField txfAge = new JTextField();
    JLabel lblSalary = new JLabel();
    JTextFieldValidatableFloat txfvfSalary = new JTextFieldValidatableFloat();
    JTextFieldValidatable txfSalaryEcho = new JTextFieldValidatable();
    JLabel lblContextMenu = new JLabel();
    JTextField txfContextMenu = new JTextField();

    public RegistrationDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try  {
            jbInit();
//            this.setUndecorated(true);
        }
        catch(Exception ex) {
            ex.printStackTrace();
        }
    }

    public RegistrationDialog() {
        this(null, "Register", true);
    }

    void jbInit() throws Exception {
        this.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
        contentPanel.setLayout(new BorderLayout());
        btnOK.setText("Register");
        btnOK.setName("OKButton");
        btnOK.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(ActionEvent e) {
                if (RegistrationDialog.this.txfUser.getText() == null || RegistrationDialog.this.txfUser.getText().length() == 0)
                    RegistrationDialog.this.jtaHint.setText("&nbsp;<font color=\"red\">User name is required<br><br>");
                else if (RegistrationDialog.this.txfPassword.getPassword().length == 0)
                    RegistrationDialog.this.jtaHint.setText("&nbsp;<font color=\"red\">Password is required<br><br>");
                else
                    dispose();
            }
        });
        panelSouth.add(btnOK, null);
        
        jtaHint.setEditable(false);
        panelNorth.setLayout(gridBagLayout1);
        jLabel1.setText("User Name");
        jLabel2.setText("Password");
        txfPassword.setColumns(30);
        txfUser.setColumns(30);

        jtaHint.setContentType("text/html");
        jtaHint.setText("&nbsp;<b>Hint:</b> you can type in any user name and password.<br><br>");
        getContentPane().setLayout(new BorderLayout());
        getContentPane().add(jtaHint, BorderLayout.NORTH);

        // For testing validation with scrolling
//        JScrollPane scrollPane = new JScrollPane();
//        contentPanel.setPreferredSize(new Dimension(500, 800));
//        scrollPane.setViewportView(contentPanel);
//        getContentPane().add(scrollPane, BorderLayout.CENTER);
        getContentPane().add(contentPanel, BorderLayout.CENTER);
        
        
        // / add display name for validation///
        txfUser.setDisplayName("User");
        txfUser.setRequired(true);
        txfUser.setErrorMessage("User is required");
        txfPassword.setDisplayName("Password");
        txfPassword.setRequired(true);
        txfPassword.setMinLength(3);
        txfPassword.setErrorMessage("Password must have a least 3 characters");
        txfBirthDate.setDisplayName("Birth Date");
        txfBirthDate.setMinValue("01/01/1800");
        txfBirthDate.setMaxValue("12/31/3000");
        txfBirthDate.setErrorMessage("Birth Date must be valid date and between 01/01/1800 and 12/31/3000");

       
        
        txfvfSalary.setDisplayName("Salary");
        txfvfSalary.setMinValue(99.55f);
        txfvfSalary.setErrorMessage("Minimum salary is 99.55 $");
        // ///////////////////////////////////
        lblContextMenu.setText("Nickname");
        txfContextMenu.setText("Right-mouse click me");
        txfContextMenu.setColumns(15);
        loginInfoPanel.setLayout(gridBagLayout1);
        userInfoPanel.setLayout(gridBagLayout1);
        lblPassword.setText("<html><font color=red>*</font>Password&nbsp;&nbsp;</html>");
        txfPassword.setColumns(15);
        lblBirthDate.setText("Birth Date      ");
        txfBirthDate.setColumns(10);
        lblAge.setText("Age");
        txfAge.setColumns(10);
        lblSalary.setText("Salary");
        txfvfSalary.setColumns(10);
        txfSalaryEcho.setColumns(10);
        txfvfSalary.getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                TraceMgr.trace(this, "changedUpdate " + e, 10);
                txfSalaryEcho.setText(txfvfSalary.getText());
            }

            public void insertUpdate(DocumentEvent e) {
                TraceMgr.trace(this, "insertUpdate " + e, 10);
                txfSalaryEcho.setText(txfvfSalary.getText());
            }

            public void removeUpdate(DocumentEvent e) {
                TraceMgr.trace(this, "removeUpdate " + e, 10);
                txfSalaryEcho.setText(txfvfSalary.getText());
            }
        });
        lblUser.setText("<html><font color=red>*</font>User&nbsp;&nbsp;</html>");
        txfUser.getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                TraceMgr.trace(this, "changedUpdate " + e, 10);
                lblUserEcho.setText(txfUser.getText());
            }

            public void insertUpdate(DocumentEvent e) {
                TraceMgr.trace(this, "insertUpdate " + e, 10);
                lblUserEcho.setText(txfUser.getText());
                if ("close".equals(txfUser.getText())) {
                    // Test multithreading
                    new Thread(new Runnable() {
                        public void run() {
                            try {
                                Thread.sleep(2000);
                            } catch (InterruptedException e) {}
                            new LoginDialog().setVisible(true);
                        }
                    }).start();
                    dispose();
                }
            }

            public void removeUpdate(DocumentEvent e) {
                TraceMgr.trace(this, "removeUpdate " + e, 10);
                lblUserEcho.setText(txfUser.getText());
            }
        });
        txfUser.setColumns(15);
        lblUserEcho.setText(txfUser.getText());

        loginInfoPanel.setOpaque(false);
        userInfoPanel.setOpaque(false);

        panelNorth.setLayout(new GridBagLayout());
        panelNorth.add(loginInfoPanel, null);
        loginInfoPanel.add(lblUser, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 4));
        loginInfoPanel.add(txfUser, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        loginInfoPanel.add(lblPassword, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 4, 4));
        loginInfoPanel.add(txfPassword, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
        loginInfoPanel.add(lblContextMenu, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 4, 4));
        loginInfoPanel.add(txfContextMenu, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        loginInfoPanel.add(new JLabel("Entered name "), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 4, 4));
        loginInfoPanel.add(lblUserEcho, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 4, 4));

        panelNorth.add(userInfoPanel, null);
        userInfoPanel.add(lblBirthDate, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 4, 0, 0), 0, 0));
        userInfoPanel.add(txfBirthDate, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

        userInfoPanel.add(lblAge, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 4, 0, 0), 0, 0));
        userInfoPanel.add(txfAge, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));

        userInfoPanel.add(lblSalary, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 4, 0, 0), 0, 0));
        userInfoPanel.add(txfvfSalary, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        userInfoPanel.add(new JLabel("Entered salary "), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 4, 0, 0), 0, 0));
        userInfoPanel.add(txfSalaryEcho, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

        this.getRootPane().setDefaultButton(btnOK);
        
        contentPanel.add(panelNorth, BorderLayout.NORTH);
        contentPanel.add(panelSouth, BorderLayout.SOUTH);

        setSize(new Dimension(520, 300));
        this.setLocationRelativeTo(null);
        
        JPopupMenu componentContextMenu = createComponentContextMenu();
        ComponentUtils.setPopupMenu(txfPassword, componentContextMenu);
        ComponentUtils.setPopupMenu(txfContextMenu, componentContextMenu);
    }

    private JPopupMenu createComponentContextMenu() {
        final JPopupMenu contextMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Set Blue Background");
        item.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JPopupMenu popup = (JPopupMenu) SwingUtilities.getAncestorOfClass(JPopupMenu.class, (Component) e.getSource());
                popup.getInvoker().setBackground(new Color(205, 223, 249));
            }
        });
        contextMenu.add(item);

        item = new JMenuItem("Set Yellow background");
        item.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JPopupMenu popup = (JPopupMenu) SwingUtilities.getAncestorOfClass(JPopupMenu.class, (Component) e.getSource());
                popup.getInvoker().setBackground(new Color(239, 239, 149));
            }
        });
        contextMenu.add(item);

        item = new JMenuItem("Clear text");
        item.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JPopupMenu popup = (JPopupMenu) SwingUtilities.getAncestorOfClass(JPopupMenu.class, (Component) e.getSource());
                if (popup.getInvoker() instanceof JTextField) {
                    ((JTextField) popup.getInvoker()).setText("");
                    if (AjaxSwingManager.isAjaxSwingRunning()) {
                        // Text might have been added and cleared in the same request, so make sure browser is synchronized with the Swing component
                        ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty(popup.getInvoker(), true);
                    }
                }
            }
        });
        contextMenu.add(item);

        contextMenu.addSeparator();

        item = new JMenuItem("About AjaxSwing");
        item.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, "AjaxSwing is awesome!", "About AjaxSwing", JOptionPane.PLAIN_MESSAGE);
            }
        });
        contextMenu.add(item);
        return contextMenu;
    }
    
    public String getUserName() {
        if (this.txfUser.getText() != null && this.txfUser.getText().length() > 0)
            return this.txfUser.getText();
        else
            return "Anonymous";
            
    }


}
