package com.creamtec.ajaxswing.ui;

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

import com.creamtec.ajaxswing.core.AjaxSwingProperties;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.support.components.JEditorPane;
import com.creamtec.ajaxswing.support.old.ComponentUtils;

public class TreePanel extends JPanel implements TreeSelectionListener, ListSelectionListener {

    /**
	 * 
	 */
	private static final long serialVersionUID = -7935727182038484816L;
	BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    CustomTree jTree1;
    CustomTable jTable; 
    JEditorPane emailPane = new JEditorPane("text/html", "Email body here");
    JPanel emailsPane = new JPanel();
    JScrollPane tableScrollPane = new JScrollPane();
    JPanel panelControls = new JPanel();
    JButton btnAdd = new JButton();
    JButton btnRemove = new JButton();
    JTextField txfFolder = new JTextField();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    DemoFrame demoFrame;
    String[] emailParagraphs = {"<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.",
            "<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?",
            "<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat."
        };
    final Random rnd = new Random(2010);
    private JLabel lblFolder = new JLabel();
        

    public TreePanel(DemoFrame demoFrame, String userName) throws Exception {
        this.demoFrame = demoFrame;
        // Left tree
        this.jTree1 = new CustomTree(createTreeModel(userName));
        this.jTree1.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
        this.jTree1.addTreeSelectionListener(this);
        // this.jTree1.setRootVisible(false);
        
        initTable();
        
        // Email body
        emailPane.setEditable(false);
        
        jbInit();
        
        this.jTree1.setSelectionInterval(1, 1);
        this.jTree1.setToolTipText("Mailbox folders");
        
        new Thread(new Runnable() {
            public void run() {
                while(true) {
                    try {
                        Thread.sleep(3000);
                        emailPane.setText("Updated at " + new Date());
                        ClientAgent.getCurrentInstance().setUpdateBrowser(true);
                    }
                    catch(Exception x) {break;}
                }
            }
        }); //.start(); // - for testing updateBrowser()
    }

    private void initTable() {
        String[] columnNames = { "From", "Subject", "Received", "Bytes", "Read" };
        String[] editableColumns = { "Read" };
        ArrayTableModel model = new ArrayTableModel(new ArrayList(), columnNames, editableColumns);
        this.jTable = new CustomTable(model);
        this.jTable.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        tableScrollPane = new JScrollPane(jTable);
        this.jTable.getSelectionModel().addListSelectionListener(this);
        this.jTable.getColumnModel().getColumn(0).setPreferredWidth(120);
        this.jTable.getColumnModel().getColumn(1).setPreferredWidth(400);
        this.jTable.getColumnModel().getColumn(2).setPreferredWidth(70);
        this.jTable.getColumnModel().getColumn(3).setPreferredWidth(40);
        this.jTable.getColumnModel().getColumn(4).setPreferredWidth(40);
        this.jTable.getColumnModel().getColumn(4).setMinWidth(40);
        this.jTable.setName("EmailsTable");
        
        // Set AjaxSwing specific properties
  
//        this.jTable.getColumnModel().getColumn(4).getCellRenderer().getTableCellRendererComponent(this.jTable, Boolean.TRUE, false, false, 0, 4).set    
        initTableComponentContextMenu();
    }

    void jbInit() throws Exception {
        emailsPane.setLayout(new BorderLayout());
        //emailsPane.add(lblFolder, BorderLayout.NORTH);
        emailsPane.add(this.tableScrollPane, BorderLayout.CENTER);
        
        URL imageUrl = getClass().getResource("/images/add_folder.png");
        btnAdd.setIcon(new ImageIcon(imageUrl));
        btnAdd.setMargin(new Insets(0, 0, 0, 0));
        btnAdd.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                actionAddNode(e);
            }
        });
        btnAdd.setMnemonic('a');
        imageUrl = getClass().getResource("/images/remove_folder.png");
        btnRemove.setIcon(new ImageIcon(imageUrl));
//        btnRemove.setIcon(new ImageIcon("images\\remove_folder.png"));
        btnRemove.setMargin(new Insets(0, 0, 0, 0));
        btnRemove.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                actionRemoveNode(e);
            }
        });
        btnRemove.setMnemonic('r');
        
        txfFolder.setText("New Folder");
        txfFolder.setColumns(10);
        panelControls.setLayout(gridBagLayout1);
        jScrollPane1.setViewportView(jTree1);
        jScrollPane1.setBorder(null);
        panelControls.add(txfFolder, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(5, 5, 5, 0), 0, 0));
        panelControls.add(btnAdd, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 0), 0, 0));
        panelControls.add(btnRemove, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(5, 5, 5, 0), 0, 0));

        this.setLayout(new BorderLayout());
        this.add(panelControls, BorderLayout.NORTH);
        this.add(jScrollPane1, BorderLayout.CENTER);
        createTreeComponentContextMenu();
    }

    private void createTreeComponentContextMenu() {
        JPopupMenu contextMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Add Folder");
        item.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                actionAddNode(e);
            }
        });
        contextMenu.add(item);

        item = new JMenuItem("Remove Folder");
        item.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                actionRemoveNode(e);
            }
        });
        contextMenu.add(item);
        
        item = new JMenuItem("Disabled Menu Item");
        item.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                actionRemoveNode(e);
            }
        });
        item.setEnabled(false);
        contextMenu.add(item);
        
        ComponentUtils.setPopupMenu(jTree1, contextMenu);
    }

    private void initTableComponentContextMenu() {
        JPopupMenu contextMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Insert Test Email");
        item.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                int index = jTable.getSelectedRow();
                ArrayTableModel model = (ArrayTableModel) jTable.getModel();
                Object[] row = createTableRow(rnd);
                model.addRow(index == -1 ? 0 : index, row);
            }
        });
        contextMenu.add(item);

        item = new JMenuItem("Remove Email");
        item.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                int[] indexes = jTable.getSelectedRows();
                ArrayTableModel model = (ArrayTableModel) jTable.getModel();
                for (int i = indexes.length - 1; i >= 0; i--)
                    model.removeRow(indexes[i]);
            }
        });
        contextMenu.add(item);
        ComponentUtils.setPopupMenu(jTable, contextMenu);
    }

    void actionAddNode(ActionEvent e) {
        MutableTreeNode node = null;
        TreePath sel = jTree1.getSelectionPath();

        if (sel != null) {
            node = (MutableTreeNode) sel.getLastPathComponent();
        } else {
            node = (MutableTreeNode) jTree1.getModel().getRoot();
        }

        DefaultTreeModel treeModel = (DefaultTreeModel) jTree1.getModel();
        MutableTreeNode newNode = createTreeNode(this.txfFolder.getText(), false);
        treeModel.insertNodeInto(newNode, node, node.getChildCount());
    }

    void actionRemoveNode(ActionEvent e) {
        MutableTreeNode node = null;
        TreePath sel = jTree1.getSelectionPath();

        if (sel != null) {
            node = (MutableTreeNode) sel.getLastPathComponent();

            if (node != jTree1.getModel().getRoot()) {
                DefaultTreeModel model = (DefaultTreeModel) jTree1.getModel();
                model.removeNodeFromParent(node);
            }
        }
    }

    public TreeModel createTreeModel(String userName) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Mailbox - " + userName);
        DefaultMutableTreeNode parent;

        root.add(createTreeNode("Inbox"));
        root.add(createTreeNode("Outbox"));
        root.add(createTreeNode("Drafts"));

        parent = createTreeNode("Deleted Items");
        root.add(parent);
        parent.add(createTreeNode("Recent"));
        parent.add(createTreeNode("Archived after 2000"));
        parent.add(createTreeNode("Archived before 2000"));

        parent = createTreeNode("Junk Mail");
        root.add(parent);
        parent.add(createTreeNode("Viewed"));
        parent.add(createTreeNode("Not Viewed"));

        return new DefaultTreeModel(root);
    }

    protected DefaultMutableTreeNode createTreeNode(String text) {
        return createTreeNode(text, true);
    }
    
    protected DefaultMutableTreeNode createTreeNode(String text, boolean prepopulate) {
        NodeData nodeData = new NodeData(text, prepopulate, rnd);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(nodeData);
        return node;
    }
    
    static long time = 1287490043701L;
    static long delta = 1000*37*80*24;
    static Object[] defaultData = {
    		
            new Object[] { "Marky Mark", "This is a very interesting application", new Date(time - delta), new Integer(200), new Boolean(false) },
            new Object[] { "Bill Gates", "I will take over the world!", new Date(time - 2 * delta), new Integer(10), new Boolean(false) },
            new Object[] { "Bart Simpson", "Yo dude", new Date(time - 3 * delta), new Integer(5513), new Boolean(false) },
            new Object[] { "Barry Sanders", "We would like to invite you to participate in our online lottery", new Date(time - 4 * delta), new Integer(200), new Boolean(false) },
            new Object[] { "Xena the Warrier Princess", "Time to study the warrier ways", new Date(time - 5 * delta), new Integer(1560), new Boolean(false) },
            new Object[] { "Austin Powers", "Yeah, baby...", new Date(time - 6 * delta), new Integer(2002), new Boolean(false) },
            new Object[] { "Dr. Evil", "Where is the closest Chucky Cheese?", new Date(time - 7 * delta), new Integer(3500), new Boolean(false) }
    };
    static class NodeData {
        public String text;
        public List tableData = new ArrayList();

        public NodeData(final String text, boolean prepopulate, Random rnd) {
            this.text = text;
            if (prepopulate) {
                int maxRows = 5 + (int) (rnd.nextDouble()*50);
                if("Inbox".equals(text))    // For consistency of profiling
                    maxRows = 8;
                for(int i = 0; i < maxRows; i++) {
                    // Copy default data row because each row can be edited independently in the table
                    Object[] row = createTableRow(rnd);
                    tableData.add(row);
                }
            }
        }

        public String toString() {
            return this.text;
        }
    }

    // -----------------------  Tree selection changed
    public void valueChanged(TreeSelectionEvent e) {
        if (e != null) {
            if (e.getNewLeadSelectionPath() != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode) e.getNewLeadSelectionPath().getLastPathComponent();
                if (node.getUserObject() instanceof NodeData) {
                    NodeData nodeData = (NodeData) node.getUserObject();
                    String newText = "<html><span style=\"font-size:16px;color:#808080;font-weight:bold;margin-left:10px\">" + node.toString() + "</span></html>";
                    lblFolder.setText(newText);
                    this.demoFrame.jtaHint.setText(newText);
                    ArrayTableModel model = (ArrayTableModel) jTable.getModel();
                    jTable.getSelectionModel().clearSelection();
                    List newData = new ArrayList(nodeData.tableData);      // Copy elements because model is cleared when the tree is collapsed
                    model.setData(newData);
                    if (jTable.getRowCount() > 0) {
                        jTable.getSelectionModel().setSelectionInterval(0, 0);
                    }
                    else
                        this.emailPane.setText("");
                } else {
                	clearMailPanel();
                }
            }
            else {
                clearMailPanel();
            }
        }
    }

	private void clearMailPanel() {
		this.lblFolder.setText("");
		ArrayTableModel model = (ArrayTableModel) jTable.getModel();
		this.demoFrame.jtaHint.setText("");
		model.clear();
		this.emailPane.setText("");
	}

    // -----------------------   Table selection changed
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting() == false) {
            int row = this.jTable.getSelectedRow();
            if (row != -1) {
                String from = (String) this.jTable.getModel().getValueAt(row, 0);
                String subject = (String) this.jTable.getModel().getValueAt(row, 1);
                Date received = (Date) this.jTable.getModel().getValueAt(row, 2);
                StringBuffer emailBody = new StringBuffer();
                emailBody.append("<b>From:</b>&nbsp;");
                emailBody.append(from);
                emailBody.append("<br><b>Subject:</b>&nbsp;");
                emailBody.append(subject);
                emailBody.append("<br><b>Received:</b>&nbsp;");
                emailBody.append(received);
                emailBody.append("<br><br>");
                Random rnd = new Random(row);
                for (int i = 0; i < 3; i++) {
                    int index = (int) (rnd.nextDouble()*3);
                    emailBody.append(emailParagraphs[index]);
                }
                
                this.emailPane.setText(emailBody.toString());
            }
            else {
                this.emailPane.setText("");
            }
        }
    }

    public static Object[] createTableRow(Random rnd) {
        int random = (int) (rnd.nextDouble()*defaultData.length);
        Object[] defaultRow = (Object[]) defaultData[random];
        Object[] row = new Object[defaultRow.length];
        System.arraycopy(defaultRow, 0, row, 0, defaultRow.length);
        row[4] = new Boolean(false);
        return row;
    }
    
}